% Craig Brett's Tactical Battle scripts and stuff

By Craig Brett

##Introduction

Hello and welcome. This documentation is for the Craig Brett collection of scripts. These scripts are designed to help map creaters for Tactical Battle utilize the powerful scripting capabilities built in to the engine. These scripts and this documentation are copyright, left and any other direction Craig Brett. Anyone else taking credit for them will suffer the consequences.

##How to use the scripts

###Loading the scripts into your map pack

Firstly, to use this collection of scripts, you need to allow your map pack to use them. In your map pack's Map Pack Settings.txt file, on a blank line, put:

`load_scripts=craig_brett`

And these scripts will be loaded when someone plays your map pack. Easy!

If you already have load_scripts in your map pack, simply put a comma ',' after the last name in the list, and add me in as well.

`load_scripts=victorious,craig_brett`

###Script flags

To use script flags, such as the ones in these scripts, your map pack must be converted up to parser version 10. If your map pack isn't already, you must do this first. 

To quickly start this, in the game on the map pack selection screen, highlight the map pack you want to convert and press ctrl+u. This will do some of the initial heavy lifting for you. All you will need to do is correct any issues that the game didn't properly resolve. A common one is point flags such as auto_regen which require a true after them now. Maps themselves won't be converted to version 10, unless you go into the map editor. When you save a map that isn't converted yet in a version 10 map pack, it will convert it for you. 

Once you've moved up to version 10, your skills, units, effects, etc, will all have a `script_flags` section towards the bottom of the file, that will look something like this:

`|script_flags`

Here is where you will place the flags you want. A quick example. 

<pre>
|script_flags
transforms_into warrior
</pre>

###Arguments

Some flags take an argument after the flag. In the example above, the transforms_into flag takes the name of a unit as an argument. This allows you to pass in additional information to the script. Some flags take numbers, some flags take true or false. For ones that you want to put true for, you can also just omit the true and by the flag being there it will behave as if you put true. 

The different types of argument are outlined below:

* String: Text, words, etc. This can consist of as many words as you would like. Line breaks end the string
* Number: Numbers. Negative numbers are allowed, depending on the script. These may also be refered to as ints or integers.
* Boolean: true/false. If neither true nor false is specified for a boolean flag, it is assumed to be true. Some flags will default to true unless you specify the flag and set it as false. May also be referred to as a bool.
* Float: Floating point or decimal numbers. Negative numbers are supported.
* Percent: Takes in percentages. e.g 20%. 
* Enum: Like string, except that this string is expected to be one of several values. Specifying an argument that isn't one of the expected values will cause an error.
* Keys: A hotkey that this flag should listen out for. Written in a similar fashion to the keys in the keys.config file.
* Function: This takes in a function, similar to the old function syntax for defining script functions.

##The magic of strings

Strings are arguments that take one or many words. 

In my particular set of scripts, I have a couple of tricks you can use to take better advantage of strings for flavour text and such.

###Placeholders

Placeholders allow you to inject values into your text. This is normally limited to the units involved in a script, unless otherwise specified.

Placeholders work by wrapping a number (starting at 0) in curly braces "{}". With "{0}" being the first placeholder value possible. 

In script flags on units or on effect fizzled messages, {0} will insert the unit. On skills and effects, {0}will be the user, while {1} will be the target. On the success_message flag, {1} will refer to the target as well, unless there isn't one, in which case it will be the tile on which this skill was used.

An example, for Chelsea the good witch, is below:

<pre>
|script_flags
death_message {0} disappears in a swirl of mystic energies, which fade to nothing
</pre>

If the worst should happen to Chelsea the good witch in battle, the following will be read:

> Chelsea the good witch disappears in a swirl of mystic energies, which fade to nothing

###Multiple alternative strings

Almost all flags that take strings of text as an argument for flavour text / messages can have multiple alternatives listed. One of these strings will be chosen at random and read, allowing you to vary up the flavour text a little. 

To do this, separate your strings with the bar or pipe symbol "|". An example of a death_message is below:

<pre>
|script_flags
death_message {0} fades, leaving only their robes behind | {0} seems to evaporate before you, leaving no body behind.
</pre>

##The flags

Below, I will describe all the flags provided by these scripts and explain how to use them, giving examples where appropriate, as well as the supporting flags (i.e flags that help other flags but do nothing on their own).

###transport_capacity

Argument: number

Use on: Units

Description: This flag designates that this unit is a transport and sets the unit's capacity for carrying other units. When a unit tries to board this transport, the passenger's `transport_capacity_required` is checked to see if there will be room for this unit and if there is, the unit may board the transport. 

Example: `transport_capacity 5`

###`transport_capacity_required`

Argument: number

Use on: Units

Description: This flag is used when a unit boards a transport to show how much space this unit will take up in this transport. You may choose to have larger units taking up more space in a transport. I.e. a tank will take up more space than a soldier, etc. When a unit boards a transport, this value is checked against the transport's `transport_capacity` to see if there will be sufficient room for this unit.

Example: `transport_capacity_required 1`

###`enters_transport`

Argument: boolean

Use on: Skills

Description: This skill will attempt to board the user onto the target (a transport). If the target is not a transport or has insufficient space, the unit will not board the transport. 

Example: `enters_transport`

####supporting flags

* `enters_transport_sound` (string): A sound file to play when this skill is used to enter a transport. e.g `enters_transport_sound clunk.wav`
* `enters_transport_message` (string): A message to read out when this skill is used to enter a transport. e.g `enters_transport_message {0} climbs aboard the {1}`

###`loads_onto_transport`

Argument: boolean

Use on: Skills

Description: This script works like `enters_transport` with the target reversed. It will load the targeted unit onto the user of this skill if they are a valid transport with capacity available.

Example: `loads_onto_transport`

####supporting flags

Same as for `enters_transport`

###unloads_transport

Argument: boolean

Use on: Skills

Description: This skill will unload all transported units on the tile of the transport or onto adjacent tiles. If there isn't enough free space around the transport, the units may not all be unloaded.

Example: `unloads_transport`

####supporting flags

* `unloads_transport_sound` (string): A sound file to play when this skill is used to unload a transport. e.g `unloads_transport_sound plop.wav`
* `unloads_transport_message` (string): A message to read out when this skill is used to unload from a transport. This will happen for every unloading unit. e.g `unloads_transport_message {0} leaps out of the {1} deploying a parachute`

###`unloads_cargo_on_death`

Argument: boolean

Use on: Units

Description: This skill will unload all transported units upon the unit's death. If there is insufficient space around the transport to offload when it dies, the units will not be unloaded (and will disappear into the ether, presumably dying with their transport).

Example: `unloads_cargo_on_death`

###`adjusts_transport_capacity`

Argument: number

Use on: Skills

Description: This skill will adjust the amount of transport capacity on its target. This can be a negative number. If the negative adjustment will take the transport capacity below 0, it is capped at 0 and cannot go any lower. 

Example: `adjusts_transport_capacity 1`

###death_message

Argument: string

Use on: Units

Description: This string will be read after one of these units die. 

Example: `death_message {0} whines pitteously, rolls over and moves no more`

###`toggle_to_user_team`

Alternatives: charm

Argument: boolean

Use on: Skills, Effects

Description: If in a skill, this will permenantly move the target onto the team of the user. If this is an effect, then the unit will be on that team only as long as the effect lasts. Once the effect is removed or fizzles, the target will move back to their original team.

Example: `toggle_to_user_team`

Another example: `charm`

####supporting flags

* `toggle_team_chance` (percent): This will apply an additional chance to the skill, so the skill may succeed but the charm may still fail. Or vice versa. This allows for greater customisability in the way your team toggling works. 
* `toggle_team_needs_success` (boolean): On a skill, by default, skills with toggle_team type flags will always toggle the target's team, regardless of the skill's success. With this flag, this will only occur if this skill was successful.
* `toggle_team_success_message` (string): A message that will be read when the unit is successfully toggled teams.
* `toggle_team_failure_message` (string): A message that will be read if the unit was unsuccessfully changed to a different team.

###`toggle_to_team`

Argument: number

Use on: Skills, Effects

Description: The same as `toggle_to_user_team`, except that you may specify the number of a team to transfer the unit to. 

Example: `toggle_to_team 4`

####Supporting flags

Same as for `toggle_to_user_team`

###`toggle_team_immune`

Argument: boolean

Use on: Units

Description: This specifies that this unit will always be immune to having its team changed. This is useful for scenarios where you may want the skill to succeed or the effect to be applied but not want the unit to change teams.

Example: `toggle_team_immune`

###`untoggle_team`

Argument: boolean

Use on: Skills

Description: This skill will remove the `toggle_team` effects from a unit, moving them back to their original team. If the `toggle_team` comes from an effect, this will not remove the effect, only the `toggle_team` part of it. It is recommended to remove the effect instead.

Example: `untoggle_team`

###`transform_into`

Argument: string

Use on: Skills, Effects

Description: If in a skill, this will permenantly change this unit into the new type of unit. If in an effect, the unit will transform into the new type of unit for the duration of the effect. A slash separated list may be given to randomly pick one of the given unit types to transform into.

Example: `transform_into frog/pig`

####Supporting flags

* `transform_keeps_points` (boolean) defaults to true: When the unit is transformed, having this flag set as true (or not set) will mean that the points of the original unit are carried over onto the new unit. Where the points's maximum value changes, the unit's new point value will be relevant to the ratios of the old point. So if a unit has 15 out of 20 health and is then transformed into a unit that has a max health of 40, the unit's current health will go up to 30. If this is explicitly set to false, the transformed unit will have its default points.
* `transform_message` (string): A message that will be read when the unit is transformed. Since this is read at the time of transformation, it will have the unit's old name pre-transformation as its placeholder. To have the new value, use the `success_message` flag. This also takes an additional placeholder, `{2}`, which represents the new type of unit this unit will be turned into.
* `transform_team` (number): The number of the team the transformed unit will go onto. To move the unit onto the skill user's team, use the charm flag alongside `transform_into` instead.
* `transform_name` (string): The name of the unit once it is transformed. If none is given, it will adopt the old name it had before it was transformed, or have none at all.
* `not_transfered_on_transform` (bool): When placed on an item, if a unit in possession of this item transforms, the newly transformed unit will no longer have this item.

####Advanced transformation flags

You may wish to apply one type of transform to one type of unit and a different one to any other target of this skill or effect. Or even only transform certain types of units.

This is possible by using comma and pipe separated lists of units. To do this, first specify the type of unit that will be specially transformed, then put a pipe "|" symbol, then the unit it will be transformed into. For example:

<pre>
transform_into frog|prince
</pre>

The above example will transform any frog unit into a prince. On other units, it will do nothing. If we wanted to also turn toads into a prince as well, we could use a comma to separate this.

<pre>
transform_into frog|prince,toad|prince
</pre>

This will do the same as the above, but it would also do the transformation on toads. We can also utilize the slash "/" separator to randomise, as you can with normal transformations. In the following example, we also make it so that any cat is turned into a witch or a wizard at random.

<pre>
transform_into frog|prince,toad|prince,cat|witch/wizard
</pre>

Finally, you can have a unit that any other type of unit is transformed into. In this example, if they're not a cat, toad or frog, we turn them into a sparrow. To do this, have a unit with no pipe or other unit in the list. Like so. 

<pre>
transform_into frog|prince,toad|prince,cat|witch/wizard,sparrow
</pre>

As you can see, the last item has no pipe, so is the default transformation if the unit isn't one of the other types.

###`death_transformation`

Argument: string

Use on: Units

Description: When this unit dies, it will transform into the given unit. A '/' separated list may be given, and one of these units will be chosen at random.

Example: `death_transformation zombie/skeleton`

####Supporting flags

* `death_transformation_message` (string): A message that will be read when the unit is transformed. Since this is read at the time of transformation, it will have the unit's old name pre-transformation as its placeholder. This also takes an additional placeholder, `{1}`, which represents the new type of unit this will transform into.
* `death_transformation_team` (number): The number of the team the transformed unit will go onto. 
* `death_transformation_name` (string): The name of the unit once it is transformed. If none is given, it will adopt the old name it had before it died, or have none at all.
* `not_transfered_on_transform` (bool): When placed on an item, if a unit in possession of this item transforms, the newly transformed unit will no longer have this item.

###`revert_transformation`

Argument: boolean

Use on: Skills

Description: This skill will undo transformations placed on a unit, reverting them back to their original unit type.

Example: `revert_transformation`

###`success_message`

Argument: string

Use on: Skills

Description: This will add flavour text to a skill, which will be read if the skill succeeds.

Example: `success_message {0}'s arrow strikes true, burying itself in {1}`

###`failure_message`

Argument: string

Use on: Skills

Description: This will add flavour text to a skill, which will be read if the skill fails

Example: `failure_message {0} fires an arrow which falls short of {1}`

###`fizzle_sound`

Argument: string

Use on: Effects

Description: This plays the given sound file upon the effect fizzling. This will not occur if the effect is removed by a skill.

Example: `fizzle_sound sizzle.wav`

###`fizzle_message`

Argument: string

Use on: Effects

Description: This reads the given flavour text once the effect fizzles of its own accord. This will not happen if the effect is removed by a skill.

Example: `fizzle_message {0} wakes up suddenly`

###`move_other_unit_toward`

Argument: number

Use on: Skills

Description: This will move the target of the skill the given number of tiles closer to the user. If the path between the user and the target is blocked (i.e by impassable terrain, too many other units), the target will be bought as close as it can be before reaching the blockage. 

Example: `move_other_unit_toward 1`

####Supporting flags

* `move_other_unit_on_fail` (boolean): By default, if a skill with a `move_other_unit` type flag fails, the target will not move. This overrides this default behaviour and the target will be moved regardless of the skill's success. 
* `move_other_unit_immune` (boolean): If placed on a target unit, an effect on a target unit or an equipped item of a target unit, this unit will be immune to the movement effects of a skill with move_other_unit effects, but will still take other effects from a skill

###`move_other_unit_away`

Argument: number

Use on: Skills

Description: This will move the target of the skill the given number of tiles away from the user. If the path behind the target is blocked (i.e by impassable terrain, too many other units), the target will be sent as far away as it can be before reaching the blockage.

Example: `move_other_unit_away 2`

####Supporting flags

Same as `move_other_unit_toward`

###`critical_hit_chance`

Argument: percent

Use on: skills

Description: The percentage chance that this hit will be a critical hit. You can then apply replacement damage, restoration or effects if you so choose.

Example: `critical_hit_chance 10%`

####Supporting flags

* `critical_hit_inflict` (string): The point inflictions that will happen as a result of a critical hit. This is a replacement for any existing inflictions. Takes the format `point|value`, where point is the point to be deducted and the value is the amount (solid number, dice or random). You can also string several together with commas. E.g. `critical_hit_inflict health|5r10,mana|1`. If a point doesn't exist on a target, it will be ignored.
* `critical_hit_restore` (string): Same as for inflict, but for restoring points. Takes the same format.
* `critical_hit_defence_chance` (percent): If present on the recipient of a critical hittable skill, this number will be subtracted from the chance of landing a critical hit. Usable on units.
* `critical_hit_effect` (string): An effect that will be applied if this hit is a critical hit. 
* `critical_hit_immune` (bool): If placed on a target unit, it will be immune to critical hits (all hits will be normal hits). This applies to both inflicting critical hits and restoring critical hits. Useable on units.
* `critical_hit_message` (string): A message that will be read only after a critical hit.
* `critical_hit_chance_mod` (percent): If placed on an effect or an equipped item, this mod will be added when calculating critical hit chances.
* `critical_hit_defence_chance_mod` (percent): If placed on an effect or equipped item, this mod will be added to a unit's critical hit defence when calculating critical hit chances.

###`stack_into`

Argument: string

Use on: skills

Description: Allows you to use a skill to combine a unit with other units of the same type on the same tile into a different unit. Useful for Form Squad type abilities. The A.I does not currently understand how to use these type of skills. You must use this with the stack_number flag, and must have the prerequsite number of units on the tile where this skill is used. The target of this skill should be one of the units that will be put into the stack. Self is a good flag to have on skills like these.

Example: `stack_into zombie army`

####Supporting flags

* `stack_number` (number): The number of the type of unit needed to be a stacked unit.

###`drops_item`

Argument: string

Use on: units

Description: Causes this unit to drop the given item on death. The unit does not need to possess any of this item to drop it. The real power of this script comes in with its supporting arguments.

Example: `drops_item healing_potion`

####Supporting flags

* `drops_item_chance` (percent): The percentage chance that this unit will drop an item from this flag at all on death. Higher numbers mean a drop is more likely. 
* `drops_rare_item` (string): The unit may drop a different "rare" item instead of its normal drop. Only happens on successful drops (depending on `drops_item_chance`). The `drops_rare_item_chance` flag must also be used. 
* `drops_rare_item_chance` (percent): The percentage chance that the rare item will be dropped as opposed to the normal item. 

##Closing

Thank you for taking the time to make use of my collection of scripts. I hope you find them useful in making a more feature-filled Tactical Battle map pack. If you notice any problems or have any questions, I can be reached in the mailing list. Or alternatively by my e-mail address <a href="mailto:craigbrett17@aol.com">craigbrett17@aol.com</a>. 

My thanks go out to Ian, engine designer extraordinaire, for making Tactical Battle and the associated engine behind it. My thanks also go out to the various map pack makers, for being a friendly bunch o'people and making maps that are what make this game fun. 

Happy mapping!